cd "$master"
clear


use input\hcw_raw, clear
sort facid staff_qual
label define hcw 1 "Medical Officer" 2 "Assistant Medical Officer" 3 "Clinical Officer" 4 "Enrolled Nurse/Midwife" ///
5 "Registered Nurse/Midwife" 6 "Nurse attendant" 7 "Lab technologist" 8 "Lab technician" 9 "Specialist doctor" ///
10 "Other, specify" 11 "Other, lab attendant" 12 "Other, lab assistant" 13 "Other, nurse assistant" 14 "Other, medical attendant" 15 "Other, medical assistant"
label values staff_qual hcw
bysort  facid  (staff_qual): generate id = _n
drop if id>3
g score_temp=staff_qual
recode score_temp (1=6) (2=5) (3=4) (4=3) (5=2) (6=1)
replace score_temp=0 if score_temp>6
by facid: egen hcw_score = total(score_temp)
replace hcw_score=hcw_score/18
g temp1=1 if staff_qual==1
g temp2=1 if staff_qual==1 | staff_qual==2
g temp3=1 if staff_qual==1 | staff_qual==2 | staff_qual==3
by facid: egen mo_per = total(temp1)
replace mo_per=mo_per/3
drop if id!=1
rename facid code
keep code mo_per
save output\clean_hcw, replace
